---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-ThriftServer Overview（ThriftServer概要）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御**：明示的な権限チェックコードが確認できないため推定

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerPage.scala`（443行）
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala`（133行）
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerTab.scala`（54行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/sqlserver/` | E-01 (34行目: `WebUIPage("")`), E-03 (31行目: `SparkUITab(sparkUI, "sqlserver")`) | ○ |
| C-02 | ページタイトルは"JDBC/ODBC Server" | E-01 (53行目: `headerSparkPage(request, "JDBC/ODBC Server"...)`) | ○ |
| C-03 | 基本情報にStarted at, Time since startを表示 | E-01 (57-67行目: `generateBasicStats`) | ○ |
| C-04 | オンラインセッション数を表示 | E-01 (44行目: `store.getOnlineSessionNum`) | ○ |
| C-05 | 実行中SQL数を表示 | E-01 (47行目: `store.getTotalRunning`) | ○ |
| C-06 | Session Statisticsテーブルを生成 | E-01 (50行目: `generateSessionStatsTable`), (117-162行目) | ○ |
| C-07 | SQL Statisticsテーブルを生成 | E-01 (51行目: `generateSQLStatsTable`), (70-114行目) | ○ |
| C-08 | セッションテーブルのカラム: User, IP, Session ID, Start Time, Finish Time, Duration, Total Execute | E-01 (321-329行目: `sessionTableHeadersAndTooltips`) | ○ |
| C-09 | SQLテーブルのカラム: User, JobID, GroupID, Start Time, Finish Time, Close Time, Execution Time, Duration, Statement, State, Detail | E-01 (206-218行目: `sqlTableHeadersAndTooltips`) | ○ |
| C-10 | セッションIDはセッション詳細へのリンク付き | E-01 (338-339行目: `sessionLink`) | ○ |
| C-11 | JobIDはジョブ詳細へのリンク付き | E-01 (276-277行目: `jobURL`) | ○ |
| C-12 | store.synchronizedでデータ一貫性保証 | E-01 (40行目: `store.synchronized`) | ○ |
| C-13 | セッションテーブルのソートはsessionstatタグ | E-01 (121行目: `val sessionTableTag = "sessionstat"`) | ○ |
| C-14 | SQLテーブルのソートはsqlstatタグ | E-01 (76行目: `val sqlTableTag = "sqlstat"`) | ○ |
| C-15 | ThriftServerTabのdisplayOrderは1 | E-03 (44行目: `override def displayOrder: Int = 1`) | ○ |
| C-16 | DetailにはdetailまたはexecutePlanが表示される | E-01 (376-377行目: `Option(executionInfo.detail).filter(!_.isEmpty).getOrElse(executionInfo.executePlan)`) | ○ |
| C-17 | getOnlineSessionNumはfinishTimestamp==0をカウント | E-02 (43-44行目) | ○ |
| C-18 | getTotalRunningはisExecutionActiveをカウント | E-02 (68-69行目) | ○ |
| C-19 | isExecutionActiveはFAILED/CANCELED/TIMEDOUT/CLOSED以外 | E-02 (118-123行目) | ○ |
| C-20 | 権限による表示制御は特になし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: ThriftServerPageにはアクセス制御の明示コードがない。Spark UIフレームワーク側での制御有無は未確認
  - 候補：SecurityManager / spark.acls.enable / spark.ui.filters

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコード直読により大部分の主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Session Statisticsテーブルのカラムと表示内容が正しいか確認
- [ ] SQL Statisticsテーブルのカラムと表示内容が正しいか確認
- [ ] ToolTipsの定義値が正確に記載されているか確認
